package labirinto.tests;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JPanel;

import labirinto.Labirinto;
import labirinto.Player;
import labirinto.ui.ControlPanel;
import labirinto.ui.LabPanel;

public class LabirintoGame {
	
	private static JFrame frame;
	
	public static Frame getFrame() {
		// TODO Auto-generated method stub
		return frame;
	}
	
	public static void main(String[] args) {

		//frame
		LabirintoGame.frame = new JFrame();
	//	JFrame frame = new JFrame();
		frame.setTitle("Labirinto");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(600, 300);

		JPanel panel = new JPanel();
		frame.getContentPane().add(panel);
		panel.setLayout(new GridLayout(1, 2));
		
		//Test 1
		Labirinto lab = new Labirinto();
		Player player = new Player(lab.generateLab());
		
		player.setRoom(0, 1);
		//player.setDir(2); //primo test "manuale" senza UI
		System.out.println(player.getPos()[0]+" "+player.getPos()[1]);
		//player.setDir(3);
		
		//Test 2 e Test 3 (prima UI e poi il funzionamento generale)
		
		JPanel controlPanel = new ControlPanel(player);
		
		JPanel labPanel = new LabPanel(player);
		
		player.setRoom(0, 1);
		
		
		//test 4 con passaggi interdim e finestre dialogo
		
		frame.setVisible(true);
		panel.add(controlPanel);
		panel.add(labPanel);
		
		
		Dimension dim=
				Toolkit.getDefaultToolkit().getScreenSize();
				frame.setLocation((int)(dim.getWidth()-frame.getWidth())/2,(int)(dim.getHeight()-frame.getHeight())/2);
		
	}

	
}
